// cupomAindaNaoUtlizado.js
module.exports = async function obterCupomUnico(db) {
  async function pegarCupomDisponivel() {
    return new Promise((resolve, reject) => {

      // 1. Busca um cupom aleatório da tabela numeros
      db.query(
        `SELECT numero 
         FROM numeros 
         ORDER BY RAND() 
         LIMIT 1`,
        (error, numeros) => {
          if (error) {
            console.error("Erro ao buscar cupom lotérica", error);
            return reject({
              error: true,
              message: "Erro ao buscar cupom",
              code: 500
            });
          }

          const cupom = numeros[0]?.numero;

          // 2. Verifica se esse cupom já existe em registros
          db.query(
            `SELECT id FROM registros WHERE cupom = ? LIMIT 1`,
            [cupom],
            (error, registros) => {
              if (error) {
                console.error("Erro ao validar cupom em registros", error);
                return reject({
                  error: true,
                  message: "Erro ao validar cupom",
                  code: 500
                });
              }

              // Já utilizado → precisa tentar outro
              if (registros.length > 0) {
                return resolve(null);
              }

              // Cupom válido
              resolve(cupom);
            }
          );
        }
      );
    });
  }

  // repete até encontrar um cupom válido
  let tentativas = 0;
  while (tentativas < 50) {
    const cupom = await pegarCupomDisponivel();
    if (cupom) return cupom;
    tentativas++;
  }

  throw { error: true, message: "Não há cupons disponíveis!", code: 500 };
};
