const db = require("../../config/db");

class UnidadesRepository {

  #db = db;

  /* ================= CREATE ================= */
  async create(data) {
    try {


      await this.#db.query(
        `INSERT INTO unidades (nome, id_estado_cidade)
         VALUES (?, ?)`,
        [data.nome, data.id_estado_cidade]
      );

      return {
        success: true,
        message: "Unidade cadastrada com sucesso!",
        code: 201
      };

    } catch (error) {
      return {
        error: true,
        message: "Erro ao cadastrar unidade",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= LISTAR TODOS ================= */
  async getUnidades() {
    try {
      const unidades = await this.#db.query(
        `SELECT 
            u.id,
            u.nome,
            ec.cidade,
            ec.estado
         FROM unidades u
         INNER JOIN estado_cidade ec ON ec.id = u.id_estado_cidade`
      );

      return unidades;
    } catch (error) {
      return {
        error: true,
        message: "Erro ao buscar unidades",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= BUSCAR UM ================= */
  async getUmaUnidade(id) {
    try {
      const unidades = await this.#db.query(
        `SELECT 
            u.id,
            u.nome,
            u.id_estado_cidade,
            ec.cidade,
            ec.estado
         FROM unidades u
         INNER JOIN estado_cidade ec ON ec.id = u.id_estado_cidade
         WHERE u.id = ?`,
        [id]
      );

      if (!unidades.length) {
        return {
          error: true,
          message: "Unidade não encontrada",
          code: 404
        };
      }

      return unidades[0];
    } catch (error) {
      return {
        error: true,
        message: "Erro ao buscar unidade",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Atualiza uma unidade
   */
  async update(data) {
    try {

      if (data.id_estado_cidade) {
        const estadoCidade = await this.#db.query(
          `SELECT id FROM estado_cidade WHERE id = ?`,
          [data.id_estado_cidade]
        );

        if (!estadoCidade.length) {
          return {
            error: true,
            message: "Estado/Cidade não encontrado",
            code: 404
          };
        }
      }

      await this.#db.query(
        `UPDATE unidades 
         SET nome = ?, id_estado_cidade = ?
         WHERE id = ?`,
        [data.nome, data.id_estado_cidade, data.id]
      );

      return {
        success: true,
        message: "Unidade atualizada com sucesso!",
        code: 200
      };

    } catch (error) {
      return {
        error: true,
        message: "Erro ao atualizar unidade",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Deleta uma unidade
   */
  async delete(id) {
    try {
      await this.#db.query(
        `DELETE FROM unidades WHERE id = ?`,
        [id]
      );

      return {
        success: true,
        message: "Unidade deletada com sucesso!",
        code: 200
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao deletar unidade",
        code: 500,
        detail: error
      };
    }
  }
}

module.exports = new UnidadesRepository();
