class PrecosDTO {

  static validateCreate(data) {

    if (!data) {
      return {
        error: true,
        message: "Payload não informado",
        code: 400
      };
    }

    const { id_produto, id_unidade, preco } = data;

    if (!id_produto) {
      return {
        error: true,
        message: "id_produto é obrigatório",
        code: 400
      };
    }

    if (!id_unidade) {
      return {
        error: true,
        message: "id_unidade é obrigatório",
        code: 400
      };
    }

    if (preco === undefined || preco === null) {
      return {
        error: true,
        message: "preco é obrigatório",
        code: 400
      };
    }

    if (isNaN(preco) || Number(preco) <= 0) {
      return {
        error: true,
        message: "preco deve ser um número maior que zero",
        code: 400
      };
    }

    return {
      success: true
    };
  }

}

module.exports = PrecosDTO;
