const db = require("../../config/db");

class EstadoCidadeRepository {

  #db = db;

  /* ================= CREATE ================= */
  async create(data) {
    try {
      await this.#db.query(
        `INSERT INTO estado_cidade (cidade, estado)
         VALUES (?, ?)`,
        [data.cidade, data.estado]
      );

      return {
        success: true,
        message: "Estado/Cidade cadastrado com sucesso!",
        code: 201
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao cadastrar estado/cidade",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= LISTAR TODOS ================= */
  async getEstadosCidades() {
    try {
      const estadosCidades = await this.#db.query(
        `SELECT id, cidade, estado FROM estado_cidade`
      );

      return estadosCidades;
    } catch (error) {
      return {
        error: true,
        message: "Erro ao buscar estados/cidades",
        code: 500,
        detail: error
      };
    }
  }

  /* ================= BUSCAR UM ================= */
  async getUmEstadoCidade(id) {
    try {
      const estadosCidades = await this.#db.query(
        `SELECT id, cidade, estado 
         FROM estado_cidade 
         WHERE id = ?`,
        [id]
      );

      if (!estadosCidades.length) {
        return {
          error: true,
          message: "Estado/Cidade não encontrado",
          code: 404
        };
      }

      return estadosCidades[0];
    } catch (error) {
      return {
        error: true,
        message: "Erro ao buscar estado/cidade",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Atualiza um estado/cidade
   * @param {Object} data
   * @returns JSON referente ao status da operação
   */
  async update(data) {
    try {
      await this.#db.query(
        `UPDATE estado_cidade 
         SET cidade = ?, estado = ?
         WHERE id = ?`,
        [data.cidade, data.estado, data.id]
      );

      return {
        success: true,
        message: "Estado/Cidade atualizado com sucesso!",
        code: 200
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao atualizar estado/cidade",
        code: 500,
        detail: error
      };
    }
  }

  /**
   * Deleta um estado/cidade
   * @param {Int} id
   * @returns JSON referente ao status da operação
   */
  async delete(id) {
    try {
      await this.#db.query(
        `DELETE FROM estado_cidade WHERE id = ?`,
        [id]
      );

      return {
        success: true,
        message: "Estado/Cidade deletado com sucesso!",
        code: 200
      };
    } catch (error) {
      return {
        error: true,
        message: "Erro ao deletar estado/cidade",
        code: 500,
        detail: error
      };
    }
  }
}

module.exports = new EstadoCidadeRepository();
