const ContatosRepository = require("./contatos.repository");

class ContatosController {

  async register(req, res) {
    try {
      const data = req.body;
      const response = await ContatosRepository.create(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getContatos(req, res) {
    try {
      const response = await ContatosRepository.getContatos();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUmContato(req, res) {
    try {
      const id = req.params.id;
      const response = await ContatosRepository.getUmContato(id);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const id = req.params.id;
      const response = await ContatosRepository.delete(id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const data = req.body;
      const response = await ContatosRepository.update(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new ContatosController();
