const CentrosDeCustosRepository = require("./centro_custo.repository");

class CentrosDeCustoController {

  async register(req, res) {
    try {
      const data = req.body;
      const response = await CentrosDeCustosRepository.create(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getCentros(req, res) {
    try {
      const response = await CentrosDeCustosRepository.getCentros();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUmCentro(req, res) {
    try {
      const id = req.params.id;
      const response = await CentrosDeCustosRepository.getUmCentro(id);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const id = req.params.id;
      const response = await CentrosDeCustosRepository.delete(id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const data = req.body;
      const response = await CentrosDeCustosRepository.update(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new CentrosDeCustoController();
