const db = require("../../config/db");
const { Transform, pipeline } = require("stream");
const {
  S3Client,
  PutObjectCommand,
  GetObjectCommand,
  PutObjectAclCommand,
} = require("@aws-sdk/client-s3");
const sharp = require("sharp");
const crypto = require("crypto");
const bcrypt = require("bcrypt");
const jwt = require("../../config/auth/jwt");

class AdminService {
  async register(data) {
    const exist = await db.query(
      `SELECT email FROM admin WHERE email=? LIMIT 1`,
      [data.email],
    );

    if (exist.length > 0) {
      return {
        error: true,
        message: "Email ja cadastrado!",
        code: 400,
      };
    }

    const hashedPassword = await bcrypt.hash(data.senha, 10);
    await db.query(
      `
            INSERT INTO admin(nome, email, senha, role)
            VALUES (?,?,?, admin)
            `,
      [data.nome, data.email, hashedPassword],
    );
    return {
      sucesse: true,
      message: "admin registrado com sucesso",
      code: 200,
    };
  }

  async login(data) {
    const adminEmailSenha = await db.query(
      `SELECT * FROM admin WHERE email = ?`,
      [data.email],
    );

    if (!adminEmailSenha[0]) {
      return {
        error: true,
        message: "Email ou senha incorretos!",
        code: 401,
      };
    }

    const isMatch = await bcrypt.compare(data.senha, adminEmailSenha[0].senha);

    if (!isMatch) {
      return {
        error: true,
        message: "Email ou senha incorretos!",
        code: 401,
      };
    }

    const user = {
      id: adminEmailSenha[0].id,
      nome: adminEmailSenha[0].nome,
      email: adminEmailSenha[0].email,
      role: adminEmailSenha[0].role,
    };

    const token = await jwt.genereteToken(user);

    return {
      success: true,
      user: user,
      token: token,
      message: "Admin logado com sucesso!",
      code: 200,
    };
  }
}

module.exports = new AdminService();
