const { RestoreRequestType } = require("@aws-sdk/client-s3");
const AdminService = require("./Admin.service");

class AdminController {
  async registerAdmin(req, res) {
    try {
      const result = await AdminService.register(req.body);
      return res.status(result.code || 200).json(result);
    } catch (error) {
      return res.status(500).json({ error: error.message });
    }
  }
  async loginAdmin(req, res) {
    try {
      const result = await AdminService.login(req.body);
      return res.status(result.code || 200).json(result);
    } catch (error) {
      return res.status(500).json({ error: error.message });
    }
  }
}

module.exports = new AdminController();
